import torch
import glob
from torchvision.transforms import transforms
import pathlib
import numpy as np

""" Device """
device = torch.device("cuda" if torch.cuda.is_available() else "cpu")

""" Transforms """
transformer = transforms.Compose([
    transforms.Resize((128, 128)),
    transforms.RandomHorizontalFlip(),
    transforms.ToTensor(),
    transforms.Normalize([0.5,0.5,0.5],
                        [0.5,0.5,0.5])
])

""" Loading Data """
# Path for training and testing directory
train_path = r"/home/shivam-wiz/Downloads/MLPR___/TrainingData"
test_path = r"/home/shivam-wiz/Downloads/MLPR___/TestingData"

""" Categories """
root = pathlib.Path(train_path)
classes = sorted([str(j).split('/')[-1] for j in root.iterdir()])
num_classes = len(classes)
# Calculating the size of training and testing images
train_count = len(glob.glob(train_path + "/**/*.jpg"))
test_count = len(glob.glob(test_path + "/**/*.jpg"))

class_description = {
    "Door Art": "On The Brink",
    "Circle_Art": "Community Discs",
    "Falling_Houses": "Spring of Construction",
    "Flower_Art": "Penumbra",
    "Utility_Block": "Plaksha University Utility Block",
    "Central Campus": "Central Campus",
    "Bharti_Fourth_Floor": "Faculty Floor Bharti Academic Block",
    "Bharti_Second_Floor": "Faculty Floor Bharti Academic Block",
    "Havells_Faculty_Floor": "Faculty Floor Havells Research Block",
    "Tonnies": "Uncle Tonnies Food Joint",
    "Mohali_map": "Memory of the Land of Five Rivers"
}

data_description = {
    "Door Art": "'On the Brink' by Martand Khosla is a sculpture encapsulating the theme of regeneration amid urban upheaval. In the flux of city transformations, the artwork symbolizes the collective struggle to reconcile the past with the dynamic present. Khosla's creation serves as a visual metaphor for the interplay of thoughts shaping new futures. The sculpture's form embodies the fluid exchange of ideas, mirroring the evolving urban landscape. 'On the Brink' masterfully captures the perpetual state of flux in both thoughts and cities, offering a profound reflection on the transformative nature of human existence and the ever-renewing spirit amidst societal change.",
    "Circle_Art": "'Community Discs', a testament to creativity, epitomizes Plaksha University's commitment to innovation and collaboration. Conceived by twenty artists, this captivating wall installation, featuring 59 diverse discs, showcases a symphony of artistic mediums and techniques. From wood-cut prints to ceramics, acrylic paintings to carved sculptures, the installation seamlessly integrates contemporary and traditional art forms. It serves as a vibrant reflection of the university's ethos, highlighting the magic inherent in diversity and the dynamic interplay of ideas. Plaksha University, through endeavors like 'Community Discs', stands as a beacon of creativity, fostering an environment where varied talents converge to create something truly extraordinary.",
    "Flower_Art": "'Penumbra' by Mahima Kapoor transcends traditional artistic boundaries, aspiring to immerse viewers in a visually captivating experience. Imagined as a celestial drawing in space, the installation undergoes dynamic transformations with the sun's movement and controlled lighting. Kapoor skillfully orchestrates a visual dialogue between the solidity of metal and the ethereal softness of shadows. The work becomes a metaphorical journey, challenging viewers to step beyond comfort zones for elevated innovation. With a humanistic goal, Kapoor encourages viewers to perceive art not merely as it appears but as a profound experience, urging contemplation on the diverse paths to artistic expression and the limitless possibilities of creative exploration.",
    "Falling_Houses": "In 'Spring of Construction' by Abhishek Dodiya, the artist provides insight into his creative process, emphasizing the transformative nature of dismantling and reconstruction. Dodiya finds joy in breathing new life into discarded objects, a sentiment vividly portrayed in this work. Titled to draw attention to contemporary overdevelopment, the piece features an oversized tagara—a construction material carrier. The flowing arrangement of houses cascading onto one another becomes a symbolic representation of the ceaseless torrent of construction, inviting viewers to contemplate the relentless pace of urban expansion and the transformative potential inherent in reimagining discarded elements.",
    "Utility_Block": "Plaksha University's Utility Block stands as the administrative nucleus, housing key departments such as safety, housekeeping, maintenance, and finance. This central hub serves as the operational epicenter, accommodating numerous offices for employees. The accessibility of these crucial departments ensures swift coordination for various campus functions. Moreover, it acts as the primary contact point for grievance redressal, fostering an environment where concerns regarding facilities or services are promptly addressed. With its pivotal role in facilitating seamless operations and addressing the needs of both staff and students, the Utility Block emerges as an indispensable cornerstone within the university infrastructure.",
    "Central_Campus": "Embodied in the heart of Plaksha University is the Winter and Summer Court—an expanse of lush greenery and vibrant energy. This central enclave serves as the nexus, connecting pivotal corners of the campus. To the north and south stand the esteemed Academic buildings, A1 and A2, while to the west lies the Asha Mukul Agarwal Library. Towards the northern precincts, one encounters the communal dining hall and student residences. This locale epitomizes Plaksha's unwavering dedication to fostering green spaces and a harmonious connection with nature. Beyond its natural allure, this space transforms into a versatile venue for both social and academic engagements, playing host to classes, musical performances, and casual tête-à-têtes with friends—an amalgamation of intellectual pursuits and convivial camaraderie within the university's picturesque core.",
    "Bharti_Fourth_Floor": "On the fourth floor of the Bharti Academic Building, Plaksha University's Faculty Floor stands as an intellectual bastion, housing distinguished educators, accomplished researchers, teaching assistants, and management heads. This floor serves as a dynamic hub for academic excellence, fostering collaboration and knowledge exchange among the university's esteemed faculty. Offices of eminent professors, teaching assistants, and administrative heads converge here, creating a vibrant ecosystem of learning and mentorship. It is a space where innovative ideas are cultivated, curriculum development takes shape, and academic leadership thrives. The Faculty Floor encapsulates the essence of Plaksha's commitment to nurturing a community of scholars dedicated to shaping the future through impactful education and groundbreaking research.",
    "Bharti_Second_Floor": "On the second floor of the Bharti Academic Building, Plaksha University's Faculty Floor stands as an intellectual bastion, housing distinguished educators, accomplished researchers, teaching assistants, and management heads. This floor serves as a dynamic hub for academic excellence, fostering collaboration and knowledge exchange among the university's esteemed faculty. Offices of eminent professors, teaching assistants, and administrative heads converge here, creating a vibrant ecosystem of learning and mentorship. It is a space where innovative ideas are cultivated, curriculum development takes shape, and academic leadership thrives. The Faculty Floor encapsulates the essence of Plaksha's commitment to nurturing a community of scholars dedicated to shaping the future through impactful education and groundbreaking research.",
    "Havells_Faculty_Floor": "On the fourth floor of the Havells Research Building, Plaksha University's Faculty Floor stands as an intellectual bastion, housing distinguished educators, accomplished researchers, teaching assistants, and management heads. This floor serves as a dynamic hub for academic excellence, fostering collaboration and knowledge exchange among the university's esteemed faculty. Offices of eminent professors, teaching assistants, and administrative heads converge here, creating a vibrant ecosystem of learning and mentorship. It is a space where innovative ideas are cultivated, curriculum development takes shape, and academic leadership thrives. The Faculty Floor encapsulates the essence of Plaksha's commitment to nurturing a community of scholars dedicated to shaping the future through impactful education and groundbreaking research.",
    "Tonnies": "'Uncle Tonnies', the charming food haven proximate to the Bharti Academic Building, is a culinary treasure trove. Nestled in the heart of the university, this gem offers a delightful array of special teas, general snacks, and mouthwatering delicacies. The ambiance exudes warmth, making it a favored rendezvous spot for the university community. From the aromatic brews of their special teas to the delectable range of snacks, Uncle Tonnies crafts a sensory experience that transcends mere sustenance. The proximity to the Bharti Academic Building makes it a convenient retreat for scholars, fostering camaraderie and culinary satisfaction—an inviting culinary haven enriching the campus experience.",
    "Mohali_map": "'Memory of the Land of Five Rivers' by Santanu Dey is a 12-foot-high installation that delicately reopens the historical narrative of a state named for its five rivers. Crafted from e-waste, the artwork embodies not just artistic expression but also encapsulates the essence of time and history within its materiality. Dey's creation serves as a powerful catalyst, aiming to stir the consciousness of young minds at the university. Beyond its aesthetic appeal, the installation beckons a call for a more balanced life, urging the audience to consider environmental stewardship and conscientious consumption. Through this evocative piece, Dey navigates the intersection of art, history, and environmental awareness, leaving an indelible impression on the viewer's conscience."
}

""" Utility Functions """
def display_data_description():
    print("The classes in the dataset are: ")
    for i in range(num_classes):
        print(f"{i}.\t{class_description[classes[i]]}")
    print()
    print(f"Size of Training Dataset: {train_count}")
    print(f"Size of Testing Dataset: {test_count}")
    print()

def print_training_message(epoch, train_loss, train_accuracy, test_accuracy):
    m1 = f"Epoch: {epoch + 1}"
    m2 = f"Train Loss: {train_loss:.2f}"
    m3 = f"Train Accuracy: {train_accuracy:.2f}"
    m4 = f"Test Accuracy: {test_accuracy:.2f}"
    print(f"{m1}\t{m2}\t{m3}\t{m4}")


display_data_description()
